#include <cstdio>
#include <list>

#pragma GCC optimize("Ofast")
#pragma GCC optimize("-falign-functions")
#pragma GCC optimize("-falign-jumps")
#pragma GCC optimize("-falign-labels")
#pragma GCC optimize("-falign-loops")
#pragma GCC optimize("-fcaller-saves")
#pragma GCC optimize("-fcrossjumping")
#pragma GCC optimize("-fcse-follow-jumps")
#pragma GCC optimize("-fdelete-null-pointer-checks")
#pragma GCC optimize("-fdevirtualize")
#pragma GCC optimize("-fexpensive-optimizations")
#pragma GCC optimize("-ffast-math")
#pragma GCC optimize("-fgcse")
#pragma GCC optimize("-fgcse-lm")
#pragma GCC optimize("-fhoist-adjacent-loads")
#pragma GCC optimize("-findirect-inlining")
#pragma GCC optimize("-finline")
#pragma GCC optimize("-fipa-sra")
#pragma GCC optimize("-fno-stack-protector")
#pragma GCC optimize("-foptimize-sibling-calls")
#pragma GCC optimize("-fpartial-inlining")
#pragma GCC optimize("-fpeephole2")
#pragma GCC optimize("-freorder-blocks")
#pragma GCC optimize("-freorder-functions")
#pragma GCC optimize("-frerun-cse-after-loop")
#pragma GCC optimize("-fsched-interblock")
#pragma GCC optimize("-fsched-spec")
#pragma GCC optimize("-fschedule-insns")
#pragma GCC optimize("-fschedule-insns2")
#pragma GCC optimize("-fstrict-aliasing")
#pragma GCC optimize("-fthread-jumps")
#pragma GCC optimize("-ftree-pre")
#pragma GCC optimize("-ftree-switch-conversion")
#pragma GCC optimize("-ftree-tail-merge")
#pragma GCC optimize("-ftree-vrp")
#pragma GCC optimize("-funroll-loops")

#pragma GCC target("abm")
#pragma GCC target("avx")
#pragma GCC target("mmx")
#pragma GCC target("popcnt")
#pragma GCC target("sse")
#pragma GCC target("sse2")
#pragma GCC target("sse3")
#pragma GCC target("sse4")
#pragma GCC target("ssse3")
#pragma GCC target("tune=native")

using namespace std;
long long int typedef li;

int n;

list<int> g[200005];
int tin[200005],tout[200005],up[18][200005];
li z[200005],s[200005];

int curtime=0;
void dfs(int p, int q)
{
    tin[p]=++curtime,up[0][p]=q;
    for (auto it : g[p]) if (it!=q) dfs(it,p);
    tout[p]=curtime;
}

li fwt[200005];

void add(int i, int x)
{
    for (;i<=n;i+=(i&-i)) fwt[i]+=x;
}

li pre(int i)
{
    li res=0;
    for (;i;i-=(i&-i)) res+=fwt[i];
    return res;
}

li ss[200005];

void calc_subtree_sizes(int p, int q)
{
    ss[p]=z[p];
    for (auto it : g[p]) if (it!=q) calc_subtree_sizes(it,p),ss[p]+=ss[it];
}

list<int> centroids;
void dfs_centroid(int p, int q)
{
    bool dobar=2*ss[p]>=ss[1];
    for (auto it : g[p]) if (it!=q)
    {
        if (2*ss[it]>ss[1]) dobar=false;
        dfs_centroid(it,p);
    }

    if (dobar) centroids.push_back(p);
}

int find_centroid()
{
    centroids.clear();
    calc_subtree_sizes(1,0);
    dfs_centroid(1,0);

    int ans=1e9;
    for (auto it : centroids) if (it<ans) ans=it;
    return ans;
}

int main()
{
    scanf("%d",&n);
    for (int i=1;i<n;i++)
    {
        int u,v; scanf("%d%d",&u,&v);
        g[u].push_back(v);
        g[v].push_back(u);
    }

    dfs(1,0);
    for (int i=1;i<=n;i++) scanf("%d",z+i),add(tin[i],z[i]);
    li sumasuma=pre(curtime);

    int centroid=find_centroid();
    printf("%d\n",centroid);

    for (int k=1;k<=17;k++)
        for (int i=1;i<=n;i++)
            up[k][i]=up[k-1][up[k-1][i]];

    int q; scanf("%d",&q);
    while (q--)
    {
        int zz,bb; scanf("%d%d",&zz,&bb);
        add(tin[bb],zz),sumasuma+=zz,z[bb]+=zz;

        if (tin[centroid]<=tin[bb] && tout[centroid]>=tout[bb]) centroid=bb;
        else if (tin[bb]<=tin[centroid] && tout[bb]>=tout[centroid]);
        else
        {
            int oldcentroid=centroid,oldbb=bb;

            int tinbb=tin[bb],toutbb=tout[bb];
            for (int k=17;k>=0;k--)
            {
                int upk=up[k][centroid]; if (upk==0) continue;
                if (!(tin[upk]<=tinbb && tout[upk]>=toutbb)) centroid=upk;
            }

            tinbb=tin[centroid],toutbb=tout[centroid];
            for (int k=17;k>=0;k--)
            {
                int upk=up[k][bb]; if (upk==0) continue;
                if (!(tin[upk]<=tinbb && tout[upk]>=toutbb)) bb=upk;
            }

            li cval=pre(tout[centroid])-pre(tin[centroid]-1);
            li bval=pre(tout[bb])-pre(tin[bb]-1);

            if (2*cval>=sumasuma) centroid=oldcentroid;
            else if (2*bval>=sumasuma) centroid=oldbb;
            else centroid=up[0][centroid];
        }

        li cval=pre(tout[centroid])-pre(tin[centroid]-1);

        for (int k=17;k>=0;k--)
        {
            int upk=up[k][centroid]; if (upk==0) continue;
            li tval=pre(tout[upk])-pre(tin[upk]-1);
            if (2*tval<sumasuma) centroid=upk,cval=tval;
        }

        if (2*cval<sumasuma) centroid=up[0][centroid],cval=pre(tout[centroid])-pre(tin[centroid]-1);

        if (2*cval==sumasuma && up[0][centroid]<centroid) centroid=up[0][centroid];
        printf("%d\n",centroid);
    }
}

/*


5
1 2
2 3
3 4
4 5
1 1 1 1 1
2
8 5
6 2

*/